# Detect cycle in a directed graph
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a Directed Graph with <strong>V</strong> vertices (Numbered from <strong>0</strong> to <strong>V-1</strong>) and <strong>E</strong> edges, check whether it contains any cycle or not.</span></p>

<p><br>
<span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>

<span style="font-size:18px"><img alt="" src="data:image/png;base64,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"></span>

<span style="font-size:18px"><strong>Output:</strong> 1
<strong>Explanation</strong>: 3 -&gt; 3 is a cycle</span></pre>

<p><br>
<span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>
<img alt="" src="data:image/png;base64,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">

<span style="font-size:18px"><strong>Output:</strong> 0
<strong>Explanation</strong>: no cycle in the graph</span></pre>

<p><br>
<span style="font-size:18px"><strong>Your task:</strong></span><br>
<span style="font-size:18px">You dont need to read input or print anything. Your task is to complete the function&nbsp;<strong>isCyclic()</strong>&nbsp;which takes the integer V denoting the number of vertices and adjacency list as input parameters and returns a boolean value denoting if the given directed graph contains a cycle or not. </span></p>

<p><br>
<span style="font-size:18px"><strong>Expected Time Complexity:&nbsp;</strong>O(V + E)<br>
<strong>Expected Auxiliary Space:&nbsp;</strong>O(V)</span></p>

<p><br>
<span style="font-size:18px"><strong>Constraints:</strong><br>
1 ≤ V, E ≤ 10<sup>5</sup></span></p>
</div>